function V = HW4AlignNeedleVF(Fins,Fhn,r,Ktip,Korient )
%Virtual fixture for aligning a needle while holding tip at insertion point
%
% Fins  = local coord system at insertion point
% Fhn   = grasp Fn = Fh*Fhn, where Fh = hand coordinate system
% r     = radius of needle
% Kn    = stiffness for aligning the needle
% Ks    = stiffness resisting penetration
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

pht = Fhn*vct3(0,0,r);          % tip in hand coords
Fc  = Frame(Fins.R,Fins.p-pt);  % where hand needs to be to insert needle tip
z3  = [0,0,0];
V   = HW4VirtualFixture(Fc,-[Ktip,Ktip,Ktip],-[Ktip,Ktip,Ktip],z3,z3,z3,z3,
                        Fc.R,-[Korient,Korient,Korient],-[Korient,Korient,Korient],z3,z3);
end